unit rvhtmltest1;

interface

{$DEFINE USE_GIFIMAGE}
{$DEFINE USE_PNGOBJECT}

uses
  // Borland's
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ShellApi, ComCtrls,
  // TRichView
  RVScroll, RichView, RVStyle, CRVFData, RVFuncs, RVNormalize,
  rvhtmlimport,
  // Graphics
  {$IFDEF USE_GIFIMAGE}
  GifImage,
  {$ENDIF}
  {$IFDEF USE_PNGOBJECT}
  PngImage,
  {$ENDIF}
  // Indy
  IdBaseComponent, IdComponent, IdTCPConnection, IdTCPClient, IdHTTP;

{
  Remove dots from the defines below to enable support for Gif and Png.

  GifImage (by Anders Melander)
    http://www.torry.net/vcl/graphics/gif/gifimage.exe (original)
    http://www.trichview.com/resources/thirdparty/gifimage.zip (update)
  PngObject (by Gustavo Huffenbacher Daud)
    http://pngdelphi.sourceforge.net/
}




type
  TForm1 = class(TForm)
    RVStyle1: TRVStyle;
    RichView1: TRichView;
    RvHtmlImporter1: TRvHtmlImporter;
    Panel1: TPanel;
    btnOpen: TButton;
    OpenDialog1: TOpenDialog;
    IdHTTP1: TIdHTTP;
    btnPaste: TButton;
    StatusBar1: TStatusBar;
    procedure btnOpenClick(Sender: TObject);
    procedure RvHtmlImporter1ImageRequired2(Sender: TObject;
      const src: String; Width, Height: Integer; var Img: TGraphic);
    procedure RichView1Jump(Sender: TObject; id: Integer);
    procedure btnPasteClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    DownloadedImages: TStringList;
    procedure ClearCache;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
{ Loading HTML from file.                                                      }
procedure TForm1.btnOpenClick(Sender: TObject);
var Stream: TFileStream;
    s: String;
begin
  if OpenDialog1.Execute then
  begin
    Screen.Cursor := crHourGlass;
    Stream := TFileStream.Create(OpenDialog1.FileName, fmOpenRead);
    try
      SetLength(s, Stream.Size);
      Stream.ReadBuffer(PChar(s)^, Stream.Size);
      RvHtmlImporter1.BasePath := ExtractFilePath(OpenDialog1.FileName);
      RvHtmlImporter1.LoadHtml(s);
      NormalizeRichView(RichView1.RVData);      
      ClearCache;
    finally
      RichView1.Format;
      Stream.Free;
      Screen.Cursor := crDefault;
    end;
  end;
end;
{------------------------------------------------------------------------------}
procedure TForm1.btnPasteClick(Sender: TObject);
begin
  try
    Screen.Cursor := crHourGlass;
    RvHtmlImporter1.LoadFromClipboard;
    NormalizeRichView(RichView1.RVData);
    ClearCache;    
  finally
    RichView1.Format;
    Screen.Cursor := crDefault;
  end;
end;
{------------------------------------------------------------------------------}
{ Returns the system directory for temporal files }
function GetTempDir: String;
var l: Integer;
begin
  // Warning: : The GetTempPath function
  // does not verify that the returned
  // directory exists.
  SetLength(Result, 300);
  l := GetTempPath(300, PChar(Result));
  SetLength(Result, l);
end;
{------------------------------------------------------------------------------}
{ Returns a name for the temporal file with the given extension }
function GetTempFileName(const Ext: String): String;
var Path: String;
    v: Integer;
begin
  Path := GetTempDir+'tmp';
  v := Random(MaxInt div 2);
  repeat
    inc(v);
    Result := Path+IntToStr(v)+Ext;
  until not FileExists(Result);
end;
{------------------------------------------------------------------------------}
{ ImageRequired2 event: providing image }

procedure TForm1.RvHtmlImporter1ImageRequired2(Sender: TObject;
  const src: String; Width, Height: Integer; var Img: TGraphic);
var Stream: TMemoryStream;
    FileStream: TFileStream;
    FileName, TempFileName: String;
    pic: TPicture;
    Img2: TGraphic;
    Index: Integer;
begin
  try
    Img := nil;
    if Pos(':', src)>0 then
      FileName := src  // absolute path
    else
      FileName := RvHtmlImporter1.BasePath+src; // relative path
    if DownloadedImages.Find(FileName, Index) then begin
      Img := RV_CreateGraphics(TGraphicClass(TGraphic(DownloadedImages.Objects[Index]).ClassType));
      Img.Assign(TGraphic(DownloadedImages.Objects[Index]));
      exit;
    end;
    StatusBar1.SimpleText := 'Receiving '+FileName;
    if Pos('http://', LowerCase(FileName))=1 then begin
      { DOWNLOADING }
      Stream := TMemoryStream.Create;
      try
        // 1. downloading
        IdHTTP1.Get(FileName, Stream);
        // 2. creating temporal file
        TempFileName := GetTempFileName(ExtractFileExt(src));
        FileStream := TFileStream.Create(TempFileName, fmCreate);
        try
          FileStream.CopyFrom(Stream, 0);
        finally
          FileStream.Free;
        end;
        // 3. reading and deleting temporal file
        pic := TPicture.Create;
        try
          pic.LoadFromFile(TempFileName);
          Img := RV_CreateGraphics(TGraphicClass(pic.Graphic.ClassType));
          Img.Assign(pic.Graphic);
        finally
          pic.Free;
          DeleteFile(TempFileName);
        end;
      finally
        Stream.Free;
      end;
      end
    else begin
      { READING LOCAL FILE }
      pic := TPicture.Create;
      try
        pic.LoadFromFile(FileName);
        Img := RV_CreateGraphics(TGraphicClass(pic.Graphic.ClassType));
        Img.Assign(pic.Graphic);
      finally
        pic.Free;
      end;
    end;
    if Img<>nil then begin
      Img2 := RV_CreateGraphics(TGraphicClass(Img.ClassType));
      Img2.Assign(Img);
      DownloadedImages.AddObject(FileName, Img2)
    end;
  except
    Img.Free;
    Img := nil;
  end;
  if Img=nil then begin
    { FAILED. CREATING DEFAULT IMAGE }
    if Width=0 then
      Width := 23;
    if Height=0 then
      Height := 23;
    Img := TBitmap.Create;
    Img.Width := Width;
    Img.Height := Height;
    TBitmap(Img).Canvas.Pen.Color := clRed;
    TBitmap(Img).Canvas.Font.Color := clRed;
    TBitmap(Img).Canvas.Rectangle(0,0,Width,Height);
    TBitmap(Img).Canvas.TextOut(2, 2, '?!');
    Img2 := RV_CreateGraphics(TGraphicClass(Img.ClassType));
    Img2.Assign(Img);
    DownloadedImages.AddObject(FileName, Img2)
  end;
  StatusBar1.SimpleText := '';
end;

procedure TForm1.RichView1Jump(Sender: TObject; id: Integer);
var
  RVData: TCustomRVFormattedData;
  ItemNo: Longint;
begin
  RichView1.GetJumpPointLocation(id, RVData, ItemNo);
  //ShellExecute(0, 'open', PChar(RVData.GetItemTag(ItemNo)), nil, nil, SW_SHOW);
  Application.MessageBox(PChar(RVData.GetItemTag(ItemNo)), 'Clicked',
    MB_OK or MB_ICONINFORMATION)
end;

{------------------------------------------------------------------------------}
{ Supporting non-standard graphic formats }
// Workaround for D2-D5 bug
function CreateGraphics(GraphicClass: TGraphicClass): TGraphic;
begin
  if GraphicClass=TBitmap then
    Result := TBitmap.Create
  else if GraphicClass=TMetafile then
    Result := TMetafile.Create
  else if GraphicClass=TIcon then
    Result := TIcon.Create
  else
  {$IFDEF USE_GIFIMAGE}
  if GraphicClass=TGifImage then
    Result := TGifImage.Create
  else
  {$ENDIF}
  {$IFDEF USE_PNGOBJECT}
  if GraphicClass=TPngObject then
    Result := TPngObject.Create
  else
  {$ENDIF}
  Result := GraphicClass.Create;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  DownloadedImages := TStringList.Create;
  DownloadedImages.Sorted := True;
  DownloadedImages.Duplicates := dupIgnore;
  DownloadedImages.CaseSensitive := False;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  ClearCache;
  DownloadedImages.Free;
end;

procedure TForm1.ClearCache;
var i: Integer;
begin
  for i := 0 to DownloadedImages.Count-1 do
    DownloadedImages.Objects[i].Free;
  DownloadedImages.Clear;
end;

initialization
{$IFDEF USE_GIFIMAGE}
  TPicture.RegisterFileFormat('gif', 'Gif Image', TGifImage);
  RegisterClasses([TGifImage]);
{$ENDIF}
{$IFDEF USE_PNGOBJECT}
  TPicture.RegisterFileFormat('png', 'Png Image', TPngObject);
  RegisterClass(TPngObject);
{$ENDIF}
{$IFNDEF RICHVIEWDEF6}
  RV_CreateGraphics := CreateGraphics;
{$ENDIF}

end.
